<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    * Classe per gestire i Contenuti
    * 
    * questa funzione richiede la classe Gutil ControlloreStringhe
    * 
    */

    class Contenuto {
        private $db;
        private $id;
        private $contenutoRiferimento;
        private $posizione;
        private $lingua;
        private $tipo;
        private $categoria;
        private $mostraNellaHome;
        private $commenti;
        private $stato;
        private $punteggioSeo;
        private $template;
        private $attivaBreadcrumbs;
        private $tipoVisualizzazione;
        private $titolo;
        private $metaTitolo;
        private $mostraTitolo;
        private $descrizione;
        private $metaDescrizione;
        private $alias;
        private $cssGenerato;
        private $cssAggiuntivo;
        private $testo;
        private $foto;
        private $miniaturaFoto;
        private $etichettaImmagine;
        private $autore;
        private $dataPubblicazione;
        private $dataUltimaModifica;
        private $datiContenuto;
        
        function __construct($db,$id,$contenutoRiferimento = 0,$lingua = "",$tipo = "", $posizione = 0, $mostraNellaHome = "",$stato = "",$punteggioSeo = "",$template = "",$attivaBreadcrumbs = "",$titolo = "",$metaTitolo = "",$descrizione="", $metaDescrizione = "", $testo="", $foto = "", $miniaturaFoto = "", $etichettaImmagine = "", $autore="",$dataCreazione = "",$dataPubblicazione = "") {
            $this->db = $db;
            $this->id = $id;
            $this->contenutoRiferimento = $contenutoRiferimento;
            $this->lingua            = $lingua;
            $this->tipo              = $tipo;
            $this->posizione         = $posizione;
            $this->mostraNellaHome   = $mostraNellaHome;
            $this->stato             = $stato;
            $this->punteggioSeo      = $punteggioSeo;
            $this->template          = $template;
            $this->titolo            = $titolo;
            $this->metaTitolo        = $metaTitolo;
            $this->metaDescrizione   = $metaDescrizione;
            $this->descrizione       = $descrizione;
            $this->testo             = $testo;
            $this->foto              = $foto;
            $this->miniaturaFoto     = $foto;
            $this->etichettaImmagine = $foto;
            $this->autore            = $autore;
            $this->categoria         = 0;
            $this->dataPubblicazione = $dataPubblicazione;
            $this->datiContenuto     = array();
        }
        
        function crea() {
            $dataCreazione     = date("Y-m-d");
            $dataPubblicazione = date("Y-m-d H:i");
            $this->alias = generaAlias($this->db,$this->titolo);
            $query = "INSERT INTO geecB_contenuti (`id`, `contenutoRiferimento`, `linguaContenuto`, `tipo`, `posizione`, `categoria`, `mostraNellaHome`, `stato`, `punteggioSeo`, `template`, `attivaBreadcrumbs`, `tipoVisualizzazione`, `titolo`, `metaTitolo`, `mostraTitolo`, `metaDescrizione`, `descrizione`, `alias`, `cssGenerato`, `cssAggiuntivo`, `testo`, `abilitaCommenti`, `numeroVisite`, `foto`, `miniaturaFoto`, `etichettaImmagine`, `autore`, `dataCreazione`, `dataUltimaVisita`, `dataUltimaModifica`, `dataPubblicazione`) 
                                VALUES(NULL,$this->contenutoRiferimento,'$this->lingua','$this->tipo', $this->posizione,'$this->categoria','$this->mostraNellaHome','$this->stato','$this->punteggioSeo','$this->template','$this->attivaBreadcrumbs','$this->tipoVisualizzazione','$this->titolo','$this->metaTitolo','$this->mostraTitolo','$this->metaDescrizione','$this->descrizione','$this->alias','$this->cssGenerato','$this->cssAggiuntivo','$this->testo','$this->commenti',0,'$this->foto','','','$this->autore','$dataCreazione','$dataCreazione','$dataCreazione','$dataPubblicazione');";
            return $this->db->eseguiQueryCreazione($query);
        }
        
        function modifica() {
            if($this->alias=="") {
                $this->alias = generaAlias($this->db,$this->titolo);
            }
            $query = "UPDATE geecB_contenuti SET contenutoRiferimento=$this->contenutoRiferimento, linguaContenuto='$this->lingua', tipo='$this->tipo', posizione=$this->posizione, categoria='$this->categoria', mostraNellaHome='$this->mostraNellaHome', stato='$this->stato', punteggioSeo='$this->punteggioSeo', template='$this->template', attivaBreadcrumbs='$this->attivaBreadcrumbs', tipoVisualizzazione='$this->tipoVisualizzazione', titolo='$this->titolo', metaTitolo='$this->metaTitolo', mostraTitolo='$this->mostraTitolo', alias='$this->alias', metaDescrizione='$this->metaDescrizione', descrizione='$this->descrizione', alias='$this->alias', cssGenerato='$this->cssGenerato', cssAggiuntivo='$this->cssAggiuntivo', testo='$this->testo', abilitaCommenti='$this->commenti', foto='$this->foto', etichettaImmagine='$this->etichettaImmagine', autore='$this->autore', dataPubblicazione='$this->dataPubblicazione' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function modificaFoto($percorsoFoto) {
            $query = "UPDATE geecB_contenuti SET foto='$percorsoFoto' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geecB_contenuti",$this->id);
        }
        
        function duplica($prefisso = "Copia di", $lingua="",$tipoElementoDaDuplicare="contenuto") {
            $contenutoDaCopiare = $this->db->leggiSingolaRiga("geecB_contenuti",$this->id);
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geecB_contenuti WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geecB_contenuti SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporanea");
            
            // se la lingua non è stata specificata va messo il valore del contenuto da copiare
            if($lingua=="") {
                $lingua = $contenutoDaCopiare["linguaContenuto"];
            }
            
            // aggiorno titolo, alias, numero visite e altri campi che vanno aggiornati, c'è una differenza da fare se si sta duplicando un
            // elemento del portfolio o qualcos'altro, se è un elemento del protfolio contenutoRiferimento non va portato a 0 
            $nuovoAlias = generaAlias($this->db,$prefisso.$contenutoDaCopiare["titolo"]);
            if($tipoElementoDaDuplicare=="elementoPortfolio") {
                $this->db->eseguiQueryScrittura("UPDATE geecB_contenuti SET titolo=CONCAT('$prefisso',' ',titolo), alias='$nuovoAlias', linguaContenuto='$lingua', numeroVisite = 0, dataCreazione='".date("Y-m-d")."', dataPubblicazione = '".date("Y-m-d H:i")."' WHERE id=$idContenutoDuplicato");
            }
            else { 
                $this->db->eseguiQueryScrittura("UPDATE geecB_contenuti SET contenutoRiferimento = 0, titolo=CONCAT('$prefisso',' ',titolo), alias='$nuovoAlias', linguaContenuto='$lingua', numeroVisite = 0, dataCreazione='".date("Y-m-d")."', autore = '{$_SESSION["geecomAdmin_nomeCognome"]}', dataPubblicazione = '".date("Y-m-d H:i")."' WHERE id=$idContenutoDuplicato");
            }
            
            // duplico i componenti
            $query = "SELECT cp.*, c.tipo, c.tabellaRiferimento FROM geecB_composizionePagine AS cp JOIN geecB_componenti AS c ON cp.idComponente = c.id WHERE cp.idPagina={$this->id} ORDER BY posizione ASC";
            $result = $this->db->eseguiQueryLettura($query);
            while($componente = $result->fetch_array()) {
                $this->duplicaComponente($componente["id"], $idContenutoDuplicato);
            }
            return $idContenutoDuplicato;
        }
        
        function traduci($lingua) {
            $idContenutoTradotto = $this->duplica("Traduzione in $lingua di",$lingua);
            $this->db->eseguiQueryScrittura("UPDATE geecB_contenuti SET contenutoRiferimento='$this->id' WHERE id=$idContenutoTradotto");
            return $idContenutoTradotto;
        }
        
        function duplicaComponente($idComponente,$idContenuto=0) {
            $queryUtimaSezione  = "SELECT * FROM geecB_composizionePagine ORDER BY id DESC";
            $risSezione         = $this->db->eseguiQueryLettura($queryUtimaSezione);
            $ultimaSezione      = $risSezione->fetch_assoc();
            $progressivoSezione = $ultimaSezione["id"] +1;
            $idSezione  = "sezione$progressivoSezione";
            
            /*
             * Il campo opzionale $idContenuto ha valore diverso da 0 solo quando viene effettuata una duplicazione, in tal caso
             * bisogna considerare le tabelle del contenuto duplicato e non di quell obase
             */
            $idContenutoElementoDuplicato = ($idContenuto!=0) ? $idContenuto : $this->id;
                    
            $query    = "SELECT cp.*, c.nome AS nomeComponente, c.tipo, c.tabellaRiferimento FROM geecB_composizionePagine AS cp JOIN geecB_componenti AS c ON cp.idComponente = c.id WHERE cp.id={$idComponente}";
            $risQuery = $this->db->eseguiQueryLettura($query);
            $componente = $risQuery->fetch_assoc();
            
            $testo          = filter_var($componente["testo"],FILTER_SANITIZE_ADD_SLASHES);
            $codiceGenerato = filter_var($componente["codiceGenerato"],FILTER_SANITIZE_ADD_SLASHES);
            $script         = filter_var($componente["script"],FILTER_SANITIZE_ADD_SLASHES);
            
            if($componente["tipo"]=="componenteDinamicoPagine" || $componente["tipo"]=="componenteStrutturaPagina") {
                $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporaneaComponente SELECT * FROM {$componente["tabellaRiferimento"]} WHERE id={$componente["idElemento"]}");
                $this->db->eseguiQueryScrittura("UPDATE tabella_temporaneaComponente SET id = 0;");
                $this->db->eseguiQueryScrittura("INSERT INTO {$componente["tabellaRiferimento"]} SELECT * FROM tabella_temporaneaComponente;");
                $idElemento = $this->db->idUltimoElemento();
                $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporaneaComponente");
                $this->duplicaElementiComponente($componente,$idElemento,$idContenuto);
                
                $queryAggiornamentoNomeComponente = "UPDATE {$componente["tabellaRiferimento"]} SET nome = CONCAT('Copia di',' ',nome) WHERE id=$idElemento";
                $this->db->eseguiQueryCreazione($queryAggiornamentoNomeComponente);
                
                $queryInserimentoComponente = "INSERT INTO geecB_composizionePagine VALUES(NULL,{$componente["idComponente"]},$idContenutoElementoDuplicato,'{$componente["tipoElemento"]}',{$idElemento},{$componente["posizione"]},'$testo','$codiceGenerato','$script','{$componente["nascosto"]}','$idSezione','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["animazione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}','{$componente["altreOpzioni"]}')";
            }
            else if($componente["nomeComponente"]=="Singola risorsa") {
                $fileScaricabile    = new FileScaricabile($this->getDb(), $componente["idElemento"]);
                $idRisorsaDuplicata = $fileScaricabile->duplica();
                $altreOpzioni = filter_var(str_replace("nomeRisorsa=","nomeRisorsa=Copia di ",$componente["altreOpzioni"]),FILTER_SANITIZE_ADD_SLASHES);
                $queryInserimentoComponente = "INSERT INTO geecB_composizionePagine VALUES(NULL,{$componente["idComponente"]},$idContenutoElementoDuplicato,'{$componente["tipoElemento"]}','{$idRisorsaDuplicata}',{$componente["posizione"]},'$testo','$codiceGenerato','$script','{$componente["nascosto"]}','{$idSezione}','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["animazione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}','$altreOpzioni')";
            }
            else {
                $queryInserimentoComponente = "INSERT INTO geecB_composizionePagine VALUES(NULL,{$componente["idComponente"]},$idContenutoElementoDuplicato,'{$componente["tipoElemento"]}',{$componente["idElemento"]},{$componente["posizione"]},'$testo','$codiceGenerato','$script','{$componente["nascosto"]}','{$idSezione}','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["animazione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}','{$componente["altreOpzioni"]}')";
            }
            $idNuovoComponente = $this->db->eseguiQueryCreazione($queryInserimentoComponente);
            
            $posizioneNuovoComponente = $componente["posizione"] +1;
            $this->modificaPosizioneComponente($idNuovoComponente,$posizioneNuovoComponente,$idContenuto);
            return $idNuovoComponente;
        }
        
        /*
         * Questo metodo serve per duplicare gli elementi all'interno del componente, esempio gli elementi di un form,
         * le slide di uno slider e cosi via.
         * 
         * Usato anche per le sezioni multiple (due, tre e quattro colonne) dove va a ricreare i componenti ad essa collegata
         * 
         * @param $componente: dati del componente di partenza
         * @param $idElemento: id dell'occorrenza creata
         * 
         * Il campo opzionale $idContenuto ha valore diverso da 0 solo quando viene effettuata una duplicazione, in tal caso
         * bisogna considerare le tabelle del contenuto duplicato e non il campo $this-id
         */
        function duplicaElementiComponente($componente,$idElemento,$idContenuto=0) {
            if($componente["nomeComponente"]=="Sezione a due colonne") {
                $datiSezioneADueColonne = $this->db->leggiSingolaRiga("geec_sezioniADueColonne",$componente["idElemento"]);
                $idComponente1 = ($datiSezioneADueColonne["idComponenteSezione1"]!=0) ? $this->duplicaComponente($datiSezioneADueColonne["idComponenteSezione1"],$idContenuto) : 0;
                $idComponente2 = ($datiSezioneADueColonne["idComponenteSezione2"]!=0) ? $this->duplicaComponente($datiSezioneADueColonne["idComponenteSezione2"],$idContenuto) : 0;
                
                $queryAggiornamentoSezione = "UPDATE geec_sezioniADueColonne SET idComponenteSezione1=$idComponente1, idComponenteSezione2=$idComponente2 WHERE id=$idElemento";
                $this->db->eseguiQueryScrittura($queryAggiornamentoSezione);
            }
            else if($componente["nomeComponente"]=="Sezione a tre colonne") {
                $datiSezioneATreColonne = $this->db->leggiSingolaRiga("geec_sezioniATreColonne",$componente["idElemento"]);
                $idComponente1 = ($datiSezioneATreColonne["idComponenteSezione1"]!=0) ? $this->duplicaComponente($datiSezioneATreColonne["idComponenteSezione1"],$idContenuto) : 0;
                $idComponente2 = ($datiSezioneATreColonne["idComponenteSezione2"]!=0) ? $this->duplicaComponente($datiSezioneATreColonne["idComponenteSezione2"],$idContenuto) : 0;
                $idComponente3 = ($datiSezioneATreColonne["idComponenteSezione3"]!=0) ? $this->duplicaComponente($datiSezioneATreColonne["idComponenteSezione3"],$idContenuto) : 0;
                                
                $queryAggiornamentoSezione = "UPDATE geec_sezioniATreColonne SET idComponenteSezione1=$idComponente1, idComponenteSezione2=$idComponente2, idComponenteSezione3=$idComponente3 WHERE id=$idElemento";
                $this->db->eseguiQueryScrittura($queryAggiornamentoSezione);
            }
            else if($componente["nomeComponente"]=="Sezione a quattro colonne") {
                $datiSezioneAQuattroColonne = $this->db->leggiSingolaRiga("geec_sezioniAQuattroColonne",$componente["idElemento"]);
                $idComponente1 = ($datiSezioneAQuattroColonne["idComponenteSezione1"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione1"],$idContenuto) : 0;
                $idComponente2 = ($datiSezioneAQuattroColonne["idComponenteSezione2"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione2"],$idContenuto) : 0;
                $idComponente3 = ($datiSezioneAQuattroColonne["idComponenteSezione3"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione3"],$idContenuto) : 0;
                $idComponente4 = ($datiSezioneAQuattroColonne["idComponenteSezione4"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione4"],$idContenuto) : 0;
                
                $queryAggiornamentoSezione = "UPDATE geec_sezioniAQuattroColonne SET idComponenteSezione1=$idComponente1, idComponenteSezione2=$idComponente2, idComponenteSezione3=$idComponente3, idComponenteSezione4=$idComponente4 WHERE id=$idElemento";
                $this->db->eseguiQueryScrittura($queryAggiornamentoSezione);
            }
            else if($componente["nomeComponente"]=="Portfolio") {
                $query       = "SELECT * FROM geecB_contenuti WHERE contenutoRiferimento='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geecB_contenuti",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geecB_contenuti SET alias='copia-di-{$elementoDaCopiare["alias"]}', contenutoRiferimento=$idElemento, numeroVisite=0 WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Slider") {
                $query       = "SELECT * FROM geec_slide WHERE idSlider='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_slide",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_slide SET idSlider=$idElemento, numeroClick=0 WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Griglia contenuti") {
                $query       = "SELECT * FROM geec_immaginiGriglia WHERE idGriglia='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_immaginiGriglia",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_immaginiGriglia SET idGriglia=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Form") {
                $query       = "SELECT * FROM geec_elementiForm WHERE idForm='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_elementiForm",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_elementiForm SET idForm=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Lista") {
                $query       = "SELECT * FROM geec_elementiLista WHERE idLista='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_elementiLista",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_elementiLista SET idLista=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Contatore") {
                $query       = "SELECT * FROM geec_elementiContatore WHERE idContatore='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_elementiContatore",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_elementiContatore SET idContatore=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
        }
        
        function copiaTabellaElemento($tabella,$id) {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM $tabella WHERE id=$id");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO $tabella SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporanea");
            
            return $idContenutoDuplicato;
        }
        
        function cambiaDatiSezioneMultipla($tabella,$idSezione,$proporzioni,$allineamento) {
            $query = "UPDATE $tabella SET proporzioni = '$proporzioni', allineamento='$allineamento' WHERE id=$idSezione";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function caricaDatiDalDatabase() {
            $datiContenuto = $this->db->leggiSingolaRiga("geecB_contenuti",$this->id);
            
            $this->datiContenuto = $datiContenuto;
            $this->contenutoRiferimento = $datiContenuto["contenutoRiferimento"];
            $this->tipo               = $datiContenuto["tipo"];
            $this->tipoVisualizzazione= $datiContenuto["tipoVisualizzazione"];
            $this->stato              = $datiContenuto["stato"];
            $this->lingua             = $datiContenuto["linguaContenuto"];
            $this->titolo             = $datiContenuto["titolo"];
            $this->metaTitolo         = $datiContenuto["metaTitolo"];
            $this->mostraTitolo       = $datiContenuto["mostraTitolo"];
            $this->mostraNellaHome    = $datiContenuto["mostraNellaHome"];
            $this->alias              = $datiContenuto["alias"];
            $this->cssGenerato        = $datiContenuto["cssGenerato"];
            $this->cssAggiuntivo      = $datiContenuto["cssAggiuntivo"];
            $this->metaDescrizione    = $datiContenuto["metaDescrizione"];
            $this->descrizione        = $datiContenuto["descrizione"];
            $this->categoria          = $datiContenuto["categoria"];
            $this->testo              = $datiContenuto["testo"];
            $this->commenti           = $datiContenuto["abilitaCommenti"];
            $this->foto               = $datiContenuto["foto"];
            $this->miniaturaFoto      = $datiContenuto["miniaturaFoto"];
            $this->etichettaImmagine  = $datiContenuto["etichettaImmagine"];
            $this->punteggioSeo       = $datiContenuto["punteggioSeo"];
            $this->template           = $datiContenuto["template"];
            $this->attivaBreadcrumbs  = $datiContenuto["attivaBreadcrumbs"];
            $this->autore             = $datiContenuto["autore"];
            $this->posizione          = $datiContenuto["posizione"];
            $this->dataPubblicazione  = $datiContenuto["dataPubblicazione"];
            $this->dataUltimaModifica = $datiContenuto["dataUltimaModifica"];
        }
        
        function eliminaAssociazioneTagArticolo($idTag) {
            $query = "DELETE FROM geecB_associazioniTagArticoli WHERE idArticolo=$this->id AND idTag=$idTag";
            $this->db->eseguiQueryLettura($query);
        }
        
        function creaAssociazioneTagArticolo($idTag) {
            $query = "INSERT INTO geecB_associazioniTagArticoli VALUES(NULL,$this->id,$idTag)";
            $this->db->eseguiQueryLettura($query);
        }
        
        function modificaOpzioniSezioneComponente($id,$idSezione,$classeSezione,$aTuttaLarghezza,$margineSezione,$paddingSezione,$coloreSfondo,$percorsoImmagine,$percorsoFileVideo) {
            $queryModifica = "UPDATE geecB_composizionePagine SET idSezione='$idSezione', classeSezione='$classeSezione', aTuttaLarghezza='$aTuttaLarghezza', margineSezione='$margineSezione', paddingSezione='$paddingSezione', coloreSfondo='$coloreSfondo' WHERE id=$id";
            $this->db->eseguiQueryLettura($queryModifica);
            
            if($percorsoImmagine!="") {
                $queryModifica = "UPDATE geecB_composizionePagine SET immagineSfondo='$percorsoImmagine' WHERE id=$id";
                $this->db->eseguiQueryLettura($queryModifica);
            }
            
            if($percorsoFileVideo!="") {
                $queryModifica = "UPDATE geecB_composizionePagine SET videoSfondo='$percorsoFileVideo' WHERE id=$id";
                $this->db->eseguiQueryLettura($queryModifica);
            }
        }
        
        function eliminaImmagineSezioneComponente($idSezione) {
            $queryModifica = "UPDATE geecB_composizionePagine SET immagineSfondo='' WHERE id=$idSezione";
            $this->db->eseguiQueryLettura($queryModifica);
        }
        
        function eliminaVideoSezioneComponente($idSezione) {
            $queryModifica = "UPDATE geecB_composizionePagine SET videoSfondo='' WHERE id=$idSezione";
            $this->db->eseguiQueryLettura($queryModifica);
        }
        
        function modificaPosizioneComponente($idComponente,$posizione,$idContenuto=0) {
            if($this->tipo=="pagina" || $this->tipo=="articolo" || $this->tipo=="pagina") {            
                $tipoElemento  = "contenuto";
            }
            else {
                $tipoElemento = $this->tipo;
            }
            
            /*
             * Il campo opzionale $idContenuto ha valore diverso da 0 solo quando viene effettuata una duplicazione, in tal caso
             * bisogna considerare le tabelle del contenuto duplicato e non di quell obase
             */
            $idContenutoDaCercare = ($idContenuto!=0) ? $idContenuto : $this->id;
            
            // le occorrenze di geecB_composizionePagine prese in considerazione sono solo quelle di tipo contenuto (devono essere escluse quelle delle sezioni multiple)
            $queryPosizione = "SELECT * FROM geecB_composizionePagine WHERE idPagina=$idContenutoDaCercare AND tipoElemento LIKE '$tipoElemento' AND id != $idComponente ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geecB_composizionePagine SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geecB_composizionePagine SET posizione=$posizione WHERE id = $idComponente ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        /*
         * Questa funzione viene usata per aggiornare le posizioni delle immagini contenute nella tabella geec_immagini 
         * collegate a questo elemento. 
         * 
         * Prima di eseguire questo metodo è necessario eseguire il metodo caricaDatiDalDatabase()
         */
        function modificaPosizioneImmagine($idImmagine,$posizione) {
            $tipoImmagine   = "immagine". ucfirst($this->getTipo());
            $queryPosizione = "SELECT * FROM geec_immagini WHERE tipoImmagine LIKE '$tipoImmagine' AND idContenuto=$this->id AND id != $idImmagine ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_immagini SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_immagini SET posizione=$posizione WHERE id = $idImmagine ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function cssGenerato() {
            $queryPosizione = "SELECT * FROM geecB_composizionePagine WHERE idPagina=$this->id ORDER BY posizione ASC";
            $risComponenti  = $this->db->eseguiQueryLettura($queryPosizione);
            
            $cssGenerato = "";
            while($componente = $risComponenti->fetch_assoc()) {
                $cssGeneratoSezione = "";
                if($componente["margineSezione"]!="" || $componente["paddingSezione"]!="") {
                    $stringaMargine = ($componente["margineSezione"]!="") ? "margin:{$componente["margineSezione"]};" : "";
                    $stringaPadding = ($componente["paddingSezione"]!="") ? "padding:{$componente["paddingSezione"]};" : "";
                    $cssGeneratoSezione = "
                    #{$componente["idSezione"]} {
                        $stringaMargine
                        $stringaPadding
                    }
                    ";
                }
                $cssGenerato.= $cssGeneratoSezione;
            }
            return $cssGenerato;
        }
        
        function aggiornaCssGenerato() {
            $cssGenerato = $this->cssGenerato();
            
            $queryPosizioneElementoPrincipale = "UPDATE geecB_contenuti SET cssGenerato='$cssGenerato' WHERE id = $this->id ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function stampaComponentiContenuto($percorsoBase = "") {
            
            $datiGeecomCMS = $this->db->leggiSingolaRiga("geec_prodotti",1);
            $impostazioni  = recuperaImpostazioni($this->db);
            $linkBaseAreaAmministrativaCMS = $impostazioni["urlSito"]."/".str_replace("../","",$datiGeecomCMS["percorso"]);

            if($this->tipo=="pagina" || $this->tipo=="articolo" || $this->tipo=="pagina") {
                $tipoElemento  = "contenuto";
            }
            else {
                $tipoElemento = $this->tipo;
            }
            
            $queryComponentiDaMostrare = "SELECT c.id, c.idSezione, c.idElemento, c.nascosto, c.classeSezione, c.testo, cm.nome, cm.tipo, cm.icona, cm.paginaGestione, cm.tabellaRiferimento, c.posizione, c.margineSezione, c.paddingSezione, c.aTuttaLarghezza, c.coloreSfondo, c.immagineSfondo, c.videoSfondo FROM geecB_composizionePagine AS c JOIN geecB_componenti AS cm ON c.idComponente=cm.id WHERE c.idPagina = {$this->getId()} AND tipoElemento LIKE '$tipoElemento'  ORDER BY c.posizione ASC";
            $risComponenti = $this->db->eseguiQueryLettura($queryComponentiDaMostrare);

            // se nella pagina ci sono più di 7 componenti viene inserito anche un pulsante in 
            // alto per non costringere l'utente ad arrivare in fondo alla pagina
            if($risComponenti->num_rows>7) {
        ?>
                <button type="button" class="btn btn-success btn-block mb-3" data-toggle="modal" data-target="#aggiungi-componente"><i class="fas fa-plus"></i> Aggiungi un componente</button>
        <?php
            }
            if($risComponenti->num_rows==0) {
        ?>
                <div class="card bg-light text-center mb-3">
                    <div class="card-body">
                        Non ci sono componenti
                    </div>
                </div>
        <?php
            }
            else {

                while($componente = $risComponenti->fetch_assoc()) {
                    if($componente["tipo"]=="componenteDinamico" || $componente["tipo"]=="componenteDinamicoNonConfigurabile" || $componente["tipo"]=="pagine") {
                        $nomeElemento = "";
                    }
                    else {
                        $elemento = $this->db->leggiSingolaRiga($componente["tabellaRiferimento"],$componente["idElemento"]);
                        $nomeElemento = filter_var($elemento["nome"],FILTER_SANITIZE_ADD_SLASHES);
                    }

                    if($componente["tipo"]!="componenteDinamico") {
                        $linkModificaComponente = creaLinkModifica($componente,$linkBaseAreaAmministrativaCMS);
                        $stringaPulsanteModifica = "onclick=\"{location.href='$linkModificaComponente';}\"";
                    }
                    else {
                        $stringaPulsanteModifica = "data-toggle=\"modal\" data-target=\"#configuraComponente{$componente["id"]}";
                    }

                    $posizionePrecedente = $componente["posizione"]-1;
                    $posizioneSuccessiva = $componente["posizione"]+1;
                    $nomeComponente      = filter_var($componente["nome"],FILTER_SANITIZE_ADD_SLASHES);
                    $classeComponenteAttivato = ($componente["nascosto"]=="si") ? "nascostoSuFront" : "";
                    
                    echo"<div id=\"componentePagina{$componente["id"]}\" class=\"card mb-3 $classeComponenteAttivato\">
                        <div class=\"card-header py-1 pr-sm-1 d-sm-flex justify-content-between align-items-center text-center\">
                            <div class=\"mb-1 mb-sm-0 d-flex align-items-center justify-content-start\">
                                <small class=\"text-muted mr-3\"><em><strong>ID:</strong></em> {$componente["idSezione"]} </small>
                                <small class=\"text-muted\"><em><strong>Classi:</strong></em> {$componente["classeSezione"]} </small>
                            </div>
                            <div class=\"azioni d-flex align-items-center justify-content-end\">
                                <form class=\"d-inline-flex mr-sm-1\">
                                    <div class=\"input-group input-group-sm d-flex align-items-center\">
                                        <small class=\"text-muted mr-2\">Pos.</small>
                                        <input type=\"number\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$componente["posizione"]}\" id=\"posizioneComponente{$componente["id"]}\">
                                        <div class=\"input-group-append\">
                                            <button class=\"btn btn-primary\" type=\"button\" onclick=\"modificaPosizioneComponenteDaInput({$componente["id"]})\">Salva</button>
                                        </div>
                                    </div>
                                </form>
                                <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick={modificaPosizioneComponente({$componente["id"]},$posizionePrecedente);}><i class=\"fas fa-arrow-up\" ></i></button>
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick={modificaPosizioneComponente({$componente["id"]},$posizioneSuccessiva);}><i class=\"fas fa-arrow-down\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Configura\" onclick=\"modificaImpostazioniSezione({$componente["id"]},'{$componente["idSezione"]}','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}')\"><i class=\"fas fa-cog\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Duplica\" onclick=\"duplicaComponente({$componente["id"]})\"><i class=\"far fa-clone\"></i></button>";
                                    if($componente["nascosto"]=="si") {
                                            echo"<button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Mostra\" onclick=\"invertiValoreNascosto({$componente["id"]})\"><i class=\"far fa-eye\"></i></button>";
                                    }
                                    else {
                                            echo"<button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Nascondi\" onclick=\"invertiValoreNascosto({$componente["id"]})\"><i class=\"far fa-eye-slash\"></i></button>";
                                    }
                                    echo"<button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaComponentePagina({$componente["id"]},'{$componente["icona"]}','$nomeComponente','$nomeElemento')\" ><i class=\"far fa-trash-alt\"></i></button>
                                </div>
                           </div>
                        </div>";
                        
                        if($componente["nome"]=="Sezione a due colonne") {
                            $datiSezioneDoppia = $this->db->leggiSingolaRiga("geec_sezioniADueColonne",$componente["idElemento"]);
                            $classiDiv = explode(", ", $datiSezioneDoppia["proporzioni"]);
                        ?>
                        <div class= "card-body">
                            <div class="form-row align-items-center">
                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="inputPassword3" >Proporzioni</label>
                                    <select class="form-control" id="proporzioniSezione<?php echo $componente["idElemento"] ?>" onChange="aggiornaDivSezioneMultipla(<?php echo $componente["idElemento"] ?>)" >
                                    <?php 
                                        $arrayProporzioni = array("col-md-6, col-md-6"=>"1/2 - 1/2",
                                            "col-md-4, col-md-8"=>"1/3 - 2/3",
                                            "col-md-3, col-md-9"=>"1/4 - 3/4",
                                            "col-md-2, col-md-10"=>"1/6 - 5/6",
                                            "col-md-8, col-md-4"=>  "2/3 - 1/3",
                                            "col-md-9, col-md-3"=>  "3/4 - 1/4",
                                            "col-md-10, col-md-2"=>  "5/6 - 1/6"
                                        );
                                        foreach($arrayProporzioni as $classe=>$descrizione) {
                                            if($datiSezioneDoppia["proporzioni"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>

                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="">Allineamento <span class="d-none d-sm-inline-block">contenuti</span></label>
                                    <select class="form-control" id="allineamentoSezione<?php echo $componente["idElemento"] ?>">
                                        <?php 
                                        $arrayAllineamenti = array("d-flex align-items-start"=>"In alto",
                                            "d-flex align-items-center"=>"Al centro",
                                            "d-flex align-items-end"=>"In basso",
                                            "d-flex align-items-baseline"=>"Linea base",
                                            "d-flex align-items-stretch"=>  "Stretch"
                                        );
                                        foreach($arrayAllineamenti as $classe=>$descrizione) {
                                            if($datiSezioneDoppia["allineamento"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <button type="button" onclick="salvaDatiSezioneMultipla(<?php echo $componente["idElemento"] ?>,'geec_sezioniADueColonne')" class="btn btn-primary float-right float-md-left">Salva<i class="fas fa-check fa-fw ml-1"></i></button>
                                </div>
                            </div>
                            <hr>

                            <div class="form-row">
                                <div id="div1SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[0] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneDoppia,1,$linkBaseAreaAmministrativaCMS,'geec_sezioniADueColonne'); ?>
                                </div>
                                <div id="div2SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[1] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneDoppia,2,$linkBaseAreaAmministrativaCMS,'geec_sezioniADueColonne'); ?>
                                </div>
                            </div>
                        </div>
                    <?php            
                        }
                        else if($componente["nome"]=="Sezione a tre colonne") {
                            $datiSezioneTripla = $this->db->leggiSingolaRiga("geec_sezioniATreColonne",$componente["idElemento"]);
                            $classiDiv = explode(", ", $datiSezioneTripla["proporzioni"]);
                        ?>
                        <div class= "card-body">
                            <div class="form-row align-items-center">
                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="inputPassword3" >Proporzioni</label>
                                    <select class="form-control" id="proporzioniSezione<?php echo $componente["idElemento"] ?>" onChange="aggiornaDivSezioneMultipla(<?php echo $componente["idElemento"] ?>)" >
                                    <?php 
                                        $arrayProporzioni = array("col-md-4, col-md-4, col-md-4"=>"1/3 - 1/3 - 1/3",
                                            "col-md-6, col-md-3, col-md-3"=>"1/2 - 1/4 - 1/4",
                                            "col-md-3, col-md-6, col-md-3"=>"1/4 - 1/2 - 1/4",
                                            "col-md-3, col-md-3, col-md-6"=>"1/4 - 1/4 - 1/2"
                                        );
                                        foreach($arrayProporzioni as $classe=>$descrizione) {
                                            if($datiSezioneTripla["proporzioni"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>

                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="">Allineamento <span class="d-none d-sm-inline-block">contenuti</span></label>
                                    <select class="form-control" id="allineamentoSezione<?php echo $componente["idElemento"] ?>">
                                        <?php 
                                        $arrayAllineamenti = array("d-flex align-items-start"=>"In alto",
                                            "d-flex align-items-center"=>"Al centro",
                                            "d-flex align-items-end"=>"In basso",
                                            "d-flex align-items-baseline"=>"Linea base",
                                            "d-flex align-items-stretch"=>  "Stretch"
                                        );
                                        foreach($arrayAllineamenti as $classe=>$descrizione) {
                                            if($datiSezioneTripla["allineamento"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <button type="button" onclick="salvaDatiSezioneMultipla(<?php echo $componente["idElemento"] ?>,'geec_sezioniATreColonne')" class="btn btn-primary float-right float-md-left">Salva<i class="fas fa-check fa-fw ml-1"></i></button>
                                </div>
                            </div>
                            <hr>

                            <div class="form-row">
                                <div id="div1SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[0] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneTripla,1,$linkBaseAreaAmministrativaCMS,'geec_sezioniATreColonne'); ?>
                                </div>
                                <div id="div2SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[1] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneTripla,2,$linkBaseAreaAmministrativaCMS,'geec_sezioniATreColonne'); ?>
                                </div>
                                <div id="div3SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[2] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneTripla,3,$linkBaseAreaAmministrativaCMS,'geec_sezioniATreColonne'); ?>
                                </div>
                            </div>
                        </div>
                    <?php            
                        }
                        else if($componente["nome"]=="Sezione a quattro colonne") {
                            $datiSezioneQuadrupla = $this->db->leggiSingolaRiga("geec_sezioniAQuattroColonne",$componente["idElemento"]);
                        ?>
                        <div class= "card-body">
                            <div class="form-row align-items-center">                                
                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="">Allineamento <span class="d-none d-sm-inline-block">contenuti</span></label>
                                    <select class="form-control" id="allineamentoSezione<?php echo $componente["idElemento"] ?>">
                                        <?php 
                                        $arrayAllineamenti = array("d-flex align-items-start"=>"In alto",
                                            "d-flex align-items-center"=>"Al centro",
                                            "d-flex align-items-end"=>"In basso",
                                            "d-flex align-items-baseline"=>"Linea base",
                                            "d-flex align-items-stretch"=>  "Stretch"
                                        );
                                        foreach($arrayAllineamenti as $classe=>$descrizione) {
                                            if($datiSezioneQuadrupla["allineamento"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <button type="button" onclick="salvaDatiSezioneMultipla(<?php echo $componente["idElemento"] ?>,'geec_sezioniAQuattroColonne')" class="btn btn-primary float-right float-md-left">Salva<i class="fas fa-check fa-fw ml-1"></i></button>
                                </div>
                            </div>
                            <hr>

                            <div class="form-row">
                                <div id="div1SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,1,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                                <div id="div2SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,2,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                                <div id="div3SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,3,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                                <div id="div4SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,4,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                            </div>
                        </div>
                    <?php            
                        }
                        else {
                            echo"<div class= \"card-body py-lg-0 d-flex align-items-center\">
                                <img class=\"thumb d-none d-lg-block\" src=\"$percorsoBase{$componente["icona"]}\">
                                <span class=\"mr-3 align-self-center text-primary\"><em>{$componente["nome"]}</em></span>
                                <div class=\"input-group mr-3\">";
                                    if($componente["tipo"]=="componenteDinamicoPagine") {
                                        $queryElementiComponente = "SELECT * FROM {$componente["tabellaRiferimento"]}";
                                        $risElementoComponente   = $this->db->eseguiQueryLettura($queryElementiComponente);
                                        echo"<select class=\"form-control form-control-sm\" id=\"idElementoComponente{$componente["id"]}\">";
                                                while($elemento = $risElementoComponente->fetch_assoc()) {
                                                    if($componente["idElemento"]==$elemento["id"]) {
                                                        echo"<option value=\"{$elemento["id"]}\" selected >{$elemento["nome"]}</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"{$elemento["id"]}\">{$elemento["nome"]}</option>";
                                                    }
                                                }
                                        echo"</select>
                                        <div class=\"input-group-append\">
                                            <button type=\"button\" class=\"btn btn-primary btn-sm\" onclick=\"cambiaIdElemento({$componente["id"]})\">Salva</button>
                                        </div>";
                                    }
                                    else {
                                        echo"<span class=\"text-truncate text-muted d-block w-75\">". substr(strip_tags($componente["testo"]),0,90)."</span>";
                                    }
                                    echo"
                                </div>
                                <div class=\"btn-group\">";
                                    if($componente["tipo"]!="componenteDinamicoNonConfigurabile") {   
                                        echo "<button type=\"button\" class=\"btn btn-primary btn-sm text-nowrap\" $stringaPulsanteModifica \"><span class=\"d-none d-lg-inline-block\">Configura</span><i class=\"far fa-edit fa-fw ml-1\"></i></button>";
                                    }
                                echo"</div>
                            </div>";
                        }
                    echo"</div>";
                }
            }
        }
        
        /*
         * Metodo che mostra le immagini associate al contenuto. Utilizzato per ora solo per le gallerie.
         * 
         * NB: prima di eseguire questo metodo è necessario che sia stato eseguito il metodo caricaDatiDalDatabase
         */
        function stampaImmaginiContenuto($prefisso = "../") {
            $tipoImmagine = "immagine". ucfirst($this->tipo);
            $query = "SELECT * FROM geec_immagini WHERE tipoImmagine LIKE '$tipoImmagine' AND idContenuto=".$this->id." ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($immagine = $risultatoQuery->fetch_assoc()) {
                $posizionePrecedente = $immagine["posizione"]-1;
                $posizioneSuccessiva = $immagine["posizione"]+1;
            ?>
                <div id="immagineContenuto<?php echo $immagine["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded">
                    <div class="form-row">
                        <div class="col-xl-3 mb-2 mb-xl-0">
                            <div class="aspect-ratio-21-9">
                                <img src="<?php echo $prefisso.$immagine["percorso"] ?>">
                            </div>
                        </div>
                        <div class="col-md-8 col-xl-5 align-self-center mb-2 mb-md-0">
                            <div class="input-group input-group-sm mr-3 align-self-center">
                                <input type="text" id="didascaliaImmagine<?php echo $immagine["id"] ?>" class="form-control " value="<?php echo $immagine["descrizione"] ?>" placeholder="Diascalia" aria-label="Didascalia" aria-describedby="didascalia">
                                <div class="input-group-append">
                                    <button type="button" class="btn btn-primary" onclick="modificaDidascaliaImmagine('<?php echo $prefisso ?>',<?php echo $immagine["id"] ?>)">Salva</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-xl-2 align-self-center">
                            <form>
                                <div class="input-group input-group-sm d-flex align-items-center">
                                    <small class="text-muted mr-2">Pos.</small>
                                    <input type="number" id="posizioneImmagineContenuto<?php echo $immagine["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $immagine["posizione"] ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="modificaPosizioneImmagineContenutoDaInput('<?php echo $prefisso ?>',<?php echo $this->id; ?>,<?php echo $immagine["id"]; ?>)">Salva</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-xl-2 align-self-center text-right azioni">
                            <div class="btn-group" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="modificaPosizioneImmagineContenuto('<?php echo $prefisso ?>',<?php echo $this->getId(); ?>,<?php echo $immagine["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="modificaPosizioneImmagineContenuto('<?php echo $prefisso ?>',<?php echo $this->getId(); ?>,<?php echo $immagine["id"]; ?>,<?php echo $posizioneSuccessiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="rendiImmagineInEvidenzaContenuto('<?php echo $prefisso ?>',<?php echo $this->getId(); ?>,'<?php echo $immagine["percorso"]; ?>');" data-original-title="Metti in evidenza"><i class="far fa-image"></i></button>
                                <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaOccorrenzaImmagine('<?php echo $prefisso ?>',<?php echo $immagine["id"]; ?>,'<?php echo $immagine["percorso"]; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        /*
         * Metodo che consente di stampare il box delle traduzioni che compare nella pagina creaContenuto.php
         * 
         * ha bisogno di recuperare la variabile globale contenente le lingue
         */
        function stampaBoxTraduzioni($prefisso = "../") {
                $lingue = $GLOBALS["lingue"];
                if($this->getContenutoRiferimento()==0) {
                    $queryTraduzioni = "SELECT * FROM geecB_contenuti WHERE contenutoRiferimento={$this->getId()} AND tipo LIKE '{$this->getTipo()}'";
                }
                else {
                    $queryTraduzioni = "SELECT * FROM geecB_contenuti WHERE id={$this->getContenutoRiferimento()} OR (contenutoRiferimento={$this->getContenutoRiferimento()} AND tipo LIKE '{$this->getTipo()}' AND id!={$this->getId()})";
                }

                $result = $this->db->eseguiQueryLettura($queryTraduzioni);
                if($result->num_rows>0) {
                    echo"<hr>
                    <p>Traduzioni associate:</p>";                                            
                }

                while($traduzione=$result->fetch_assoc()) {
                    unset($lingue[array_search($traduzione["linguaContenuto"], $lingue)]);
            ?>
                    <div class="d-flex justify-content-between align-items-center mb-2" id="pagina<?php echo $traduzione["id"] ?>">
                        <div>
                            <button type="button" onclick="eliminaPagina(<?php echo $traduzione["id"] ?>,'<?php echo $traduzione["titolo"] ?>')" class="btn btn-light btn-sm mr-1 text-secondary" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                            <a href="creaContenuto.php?id=<?php echo $traduzione["id"] ?>"><?php echo $traduzione["titolo"] ?></a>
                        </div>
                        <img src="<?= $prefisso.percorsoImmagineBandiera($traduzione["linguaContenuto"]) ?>" alt="<?php echo $traduzione["linguaContenuto"] ?>">
                    </div>
            <?php
                }
            ?>
            <hr>
            <div class="input-group">
                <select class="form-control" id="linguaTraduzione">
                    <option value="">Crea una traduzione...</option>
                    <?php
                        // elimina la lingua del contenuto
                        unset($lingue[array_search($this->getLingua(), $lingue)]);
                        foreach($lingue as $lingua) {
                            echo"<option value=\"$lingua\" >$lingua </option>";
                        }
                    ?>
                </select>
                <div class="input-group-append">
                    <button class="btn btn-primary" type="button" onclick="traduci(<?php echo(($this->getContenutoRiferimento()==0) ? $this->getId() : $this->getContenutoRiferimento()) ?>)">Crea</button>
                </div>
            </div>
            <?php
        }
        
        /*
         * Metodo per stampare il contenuto delle sezioni multiple (a due colonne, tre colonne e quattro colonne)
         */
        function stampaComponenteSezioneMultipla($datiSezione,$posizioneComponente,$linkBaseAreaAmministrativaCMS,$tabellaSezione) {
                $componenteSezione    = $datiSezione["idComponenteSezione$posizioneComponente"];
                $classeDivContenitore = ($componenteSezione!=0) ? "bg-light p-3 w-100" : "bg-light p-3 d-flex align-items-center w-100";
            ?>
            <div class="<?php echo $classeDivContenitore ?>">
                <?php 
                    if($componenteSezione!=0) {

                        $queryComponenteSinistra = "SELECT c.id, c.idSezione, c.idElemento, c.classeSezione, c.aTuttaLarghezza, c.margineSezione, c.paddingSezione, c.testo, cm.nome, cm.tipo, cm.icona, cm.paginaGestione, cm.tabellaRiferimento, c.posizione FROM geecB_composizionePagine AS c JOIN geecB_componenti AS cm ON c.idComponente=cm.id WHERE c.id = {$componenteSezione} ORDER BY c.posizione ASC";
                        $risComponenteSinistra   = $this->db->eseguiQueryLettura($queryComponenteSinistra);
                        $datiComponenteSezione   = $risComponenteSinistra->fetch_assoc();
                        $nomeComponenteSezione   = filter_var($datiComponenteSezione["nome"],FILTER_SANITIZE_ADD_SLASHES);
                        if($datiComponenteSezione["tipo"]=="componenteDinamico") {
                            $nomeElemento = "";
                        }
                        else {
                            $elemento = $this->db->leggiSingolaRiga($datiComponenteSezione["tabellaRiferimento"],$datiComponenteSezione["idElemento"]);
                            $nomeElemento = filter_var($elemento["nome"],FILTER_SANITIZE_ADD_SLASHES);
                        }
                ?>
                    <div class="azioni">
                        <div class="btn-group" role="group" aria-label="">
                            <button onclick="eliminaComponenteSezione(<?php echo $componenteSezione ?>,<?php echo $datiSezione["id"] ?>,<?php echo $posizioneComponente ?>,'<?php echo $datiComponenteSezione["icona"] ?>','<?php echo $nomeComponenteSezione ?>','<?php echo $nomeElemento ?>','<?php echo $tabellaSezione ?>')" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                        </div>
                    </div>
                    <div class="text-center w-100">
                        <div class="d-flex align-items-center text-center">
                            <div class="w-100">
                                <img src="<?php echo $datiComponenteSezione["icona"] ?>" class="thumb mr-0 d-none d-lg-inline-block">
                                <span class="text-primary"><em><?php echo $datiComponenteSezione["nome"] ?></em></span>
                            </div>
                        </div>

                        <?php 
                            if($datiComponenteSezione["tipo"]!="componenteDinamico" && $datiComponenteSezione["tipo"]!="componenteStrutturaPagina") {
                                $linkModificaComponente = creaLinkModifica($datiComponenteSezione,$linkBaseAreaAmministrativaCMS);
                                $stringaPulsanteModifica = "onclick=\"{location.href='$linkModificaComponente';}\"";

                                ?>
                                <div class="input-group mb-3 w-100 mx-auto d-flex justify-content-center">
                                    <div class="input-group-append">
                                        <select class="form-control form-control-sm" id="idElementoComponente<?php echo $componenteSezione ?>">
                                        <?php
                                            $queryElementiComponente = "SELECT * FROM {$datiComponenteSezione["tabellaRiferimento"]}";
                                            $risElementoComponente   = $this->db->eseguiQueryLettura($queryElementiComponente);
                                            while($elemento = $risElementoComponente->fetch_assoc()) {
                                                if($datiComponenteSezione["idElemento"]==$elemento["id"]) {
                                                    echo"<option value=\"{$elemento["id"]}\" selected >{$elemento["nome"]}</option>";
                                                }
                                                else {
                                                    echo"<option value=\"{$elemento["id"]}\">{$elemento["nome"]}</option>";
                                                }
                                            }
                                        ?>
                                        </select>
                                        <button type="button" class="btn btn-primary btn-sm" onclick="cambiaIdElemento(<?php echo $componenteSezione ?>)">Salva</button>
                                    </div>
                                </div>
                                <?php
                            }
                            else {
                                echo"<span class=\"text-truncate text-muted d-block mx-auto\">". substr(strip_tags($datiComponenteSezione["testo"]),0,90)."</span>";
                                $stringaPulsanteModifica = "data-toggle=\"modal\" data-target=\"#configuraComponente{$datiComponenteSezione["id"]}\"";
                            }
                        ?>
                        <button type="button" class="btn btn-primary btn-sm text-nowrap my-3"  <?php echo $stringaPulsanteModifica ?>><span class="d-none d-lg-inline-block">Configura</span><i class="far fa-edit fa-fw ml-1"></i></button>
                    </div>
                <?php
                    }
                    else {
                ?>
                        <button type="button" class="btn btn-success btn-sm btn-block mb-3 mb-md-0" onclick="apriPopupAggiungiComponenteSezione(<?php echo $datiSezione["id"] ?>,<?php echo $posizioneComponente ?>,'<?php echo $tabellaSezione ?>')"><i class="fas fa-plus"></i> Aggiungi un componente</button>
                <?php
                    }
                ?>
            </div>
            <?php
        }
        
        /*
         * Esegue l'analisi SEO di un contenuto, viene invocato solo nella pagina
         * contenuti/creaContenuto.php dopo un aggiornamento o dopo la creazione di
         * un nuovo elemento
         */
        function eseguiAnalisiSeo() {

            //variabili che memorizzano l'indicatore per la seo
            $seoPositivo = "<span class=\"badge badge-success p-2\">BUONA</span>";
            $seoDiscreto = "<span class=\"badge badge-warning p-2\">DISCRETA</span>";
            $seoNegativo = "<span class=\"badge badge-danger p-2\">SCADENTE</span>";
        
            $seoPositivoTesto = "buona";
            $seoDiscretoTesto = "discreta";
            $seoNegativoTesto = "scadente";
            $punteggioSeo = 0;

            //inizializzazione array che contiene i risultati
            $analisiSeo = array();
            $suggerimenti = array();
            $analisiSeo["esito"] = $seoNegativo;
            $analisiSeo["esitoTesto"] = $seoNegativoTesto;

            //analisi titolo
            $numeroCaratteriTitolo = strlen($this->titolo);
            if ($numeroCaratteriTitolo > 20 && $numeroCaratteriTitolo < 60) {
                $punteggioSeo += 1;
            }

            //analisi meta titolo
            $numeroCaratteriMetaTitolo = strlen($this->metaTitolo);
            if($numeroCaratteriMetaTitolo==0) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>meta titolo</strong> è vuoto, l'indicizzazione di questo contenuto. sarà molto difficile</p>";
                $punteggioSeo -= 2;
            }
            else if($numeroCaratteriMetaTitolo<20) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>meta titolo</strong> è troppo corto, solo $numeroCaratteriMetaTitolo caratteri. Il numero di caratteri ottimale è tra i 20 e i 60.</p>";
                $punteggioSeo -= 1;
            }
            
            //analisi meta descrizione
            $numeroCaratteriDescrizione = strlen($this->metaDescrizione);
            if($numeroCaratteriDescrizione==0) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>meta descrizione</strong> è assente, inseriscila per migliorare l'indicizzazione di questo contenuto.</p>";
                $punteggioSeo -= 1;
            }
            else if ($numeroCaratteriDescrizione > 0 && $numeroCaratteriDescrizione <= 40) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>meta descrizione</strong> è troppo corta, solo $numeroCaratteriDescrizione caratteri. Il numero di caratteri ottimale è tra i 120 e i 160.</p>";
                $punteggioSeo += 1;
            }
            else if($numeroCaratteriDescrizione > 40 && $numeroCaratteriDescrizione < 160) {
                $punteggioSeo += 2;
            }

            //analisi sottotitolo, solo per gli articoli
            $numeroCaratteriSottotitolo = strlen($this->descrizione);
            if($numeroCaratteriSottotitolo==0 && $this->tipo=="articolo") {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>sottotitolo</strong> è assente, inseriscilo per migliorare l'indicizzazione di questo contenuto.</p>";
                $punteggioSeo -= 1;
            }
            else if ($numeroCaratteriSottotitolo > 0 && $numeroCaratteriSottotitolo <= 40  && $this->tipo=="articolo") {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>sottotitolo</strong> è troppo corto, solo $numeroCaratteriSottotitolo caratteri. La dimensione ottimale è tra i 100 e i 200 caratteri.</p>";
            }
            else if($numeroCaratteriSottotitolo > 40 && $numeroCaratteriSottotitolo < 200 && $this->tipo=="articolo") {
                $punteggioSeo += 1;
            }

            //analisi testo
            $numeroCaratteriTesto = $this->contaTestoContenuto();
            if($numeroCaratteriTesto == 0) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è assente, indicizzare questo contenuto sarà molto difficile.</p>";
            }
            else if($numeroCaratteriTesto > 0 && $numeroCaratteriTesto < 700) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è troppo corto, solo $numeroCaratteriTesto caratteri. Le dimensioni minime sono di almeno 500 caratteri, quelle ottimali oltre i 1000 caratteri.</p>";
            }
            else if ($numeroCaratteriTesto >700 && $numeroCaratteriTesto < 1000) {
                $punteggioSeo += 1;
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è un po' corto, $numeroCaratteriTesto caratteri. Le dimensioni ottimali sono di almeno 1000 caratteri.</p>";
            }
            else if ($numeroCaratteriTesto > 1000) {
                $punteggioSeo += 2;
            }
            
            ////controllo presenza tag h3, h4 e gli altri tag h
            if(strpos($this->testo,"<h1>")>0 && $this->tipo != "pagina") { // controllo presenza tag h1 (solo per articoli e gallerie, perché in questi tipi di contenuti il link viene posto sul sito)
                $punteggioSeo -= 1;
            }
            else if($numeroCaratteriTesto>1500 && (strpos($this->testo,"<h3>")>0 || strpos($this->testo,"<h4>")>0 || strpos($this->testo,"<h5>")>0 || strpos($this->testo,"<h6>")>0)) {
                $punteggioSeo += 1;
            }

            //analisi presenza immagini
            $numeroImmagini = 0;
            if ($this->foto != "") {
                $numeroImmagini ++;
            }
            $numeroImmagini += substr_count($this->testo,"<img");
            
            // controllo se ci sono immagini inserite con il componente immagini
            $queryComponenteImmagine = "SELECT * FROM geecB_composizionePagine WHERE idComponente=23 AND idPagina = $this->id";
            $risComponentiImmagini   = $this->db->eseguiQueryLettura($queryComponenteImmagine);
            $numeroImmagini          += $risComponentiImmagini->num_rows;

            if($numeroImmagini>0) {
                $punteggioSeo += 1;
            }
            else {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> <strong>Non ci sono immagini</strong> in questo contenuto, inseriscine almeno una.</p>";
            }

            //assegnazione valutazione
            if($punteggioSeo > 5) {
                $analisiSeo["esito"]      = $seoPositivo;
                $analisiSeo["esitoTesto"] = $seoPositivoTesto;
            }
            else if($punteggioSeo == 3 || $punteggioSeo == 4 || $punteggioSeo == 5) {
                $analisiSeo["esito"]      = $seoDiscreto;
                $analisiSeo["esitoTesto"] = $seoDiscretoTesto;
            }
            $analisiSeo["suggerimenti"] = $suggerimenti;
            return $analisiSeo;
        }
    
        /*
         * Questa funzione controlla il testo del contenuto, contando i caratteri della colonan testo e 
         * di ogni componente testo
         */
        function contaTestoContenuto() {
            $numeroCaratteriTesto = strlen($this->testo);
            $queryComponenteTesto = "SELECT * FROM geecB_composizionePagine WHERE (idComponente=14 OR idComponente=15 OR idComponente=28) AND idPagina = $this->id";
            $risComponentiTesto   = $this->db->eseguiQueryLettura($queryComponenteTesto);
            while($componenteTesto = $risComponentiTesto->fetch_assoc()) {
                if($componenteTesto["idComponente"]==28) {
                    $datiSezioneSdoppiata = $this->db->leggiSingolaRiga("geec_sezioniSdoppiate",$componenteTesto["idElemento"]);
                    $numeroCaratteriTesto += strlen(strip_tags($datiSezioneSdoppiata["testo"]));
                }
                else {                
                    $numeroCaratteriTesto += strlen(strip_tags($componenteTesto["testo"]));
                }
            }
            return $numeroCaratteriTesto;
        }
        
        function invertiStato() {
            if($this->stato=="pubblicato") {
                $statoAggiornato = "bozza";
            }
            else {
                $statoAggiornato = "pubblicato";
            }
            
            $queryModifica   = "UPDATE geecB_contenuti SET stato='$statoAggiornato' WHERE id=$this->id";                
            $this->db->eseguiQueryLettura($queryModifica);
            return $statoAggiornato;
        }
        
        function invertiValoreNascostoPerUnComponente($idComponente) {
            $componenteDaModificare = $this->db->leggiSingolaRiga("geecB_composizionePagine",$idComponente);
            
            if($componenteDaModificare["nascosto"]=="si") {
                $valoreAggiornato = "no";
            }
            else {
                $valoreAggiornato = "si";
            }
            
            $queryModifica   = "UPDATE geecB_composizionePagine SET nascosto='$valoreAggiornato' WHERE id=$idComponente";                
            $this->db->eseguiQueryLettura($queryModifica);
            return $valoreAggiornato;
        }
        
        // getter & setter
        function getDb() {
            return $this->db;
        }

        function getId() {
            return $this->id;
        }

        function getContenutoRiferimento() {
            return $this->contenutoRiferimento;
        }

        function getPosizione() {
            return $this->posizione;
        }
        
        function getLingua() {
            return $this->lingua;
        }

        function getTipo() {
            return $this->tipo;
        }

        function getAutore() {
            return $this->autore;
        }
        
        function getCategoria() {
            return $this->categoria;
        }

        function getMostraNellaHome() {
            return $this->mostraNellaHome;
        }

        function getStato() {
            return $this->stato;
        }

        function getPunteggioSeo() {
            return $this->punteggioSeo;
        }

        function getTemplate() {
            return $this->template;
        }

        function getAttivaBreadcrumbs() {
            return $this->attivaBreadcrumbs;
        }

        function getTipoVisualizzazione() {
            return $this->tipoVisualizzazione;
        }

        function getTitolo() {
            return $this->titolo;
        }

        function getMetaTitolo() {
            return $this->metaTitolo;
        }
        
        public function getMostraTitolo() {
            return $this->mostraTitolo;
        }

        function getMetaDescrizione() {
            return $this->metaDescrizione;
        }
        
        function getDescrizione() {
            return $this->descrizione;
        }

        function getAlias() {
            return $this->alias;
        }
        
        public function getCssGenerato() {
            return $this->cssGenerato;
        }
        
        function getCssAggiuntivo() {
            return $this->cssAggiuntivo;
        }

        function getTesto() {
            return $this->testo;
        }
                
        function getFoto() {
            return $this->foto;
        }
        
        public function getMiniaturaFoto() {
            return $this->miniaturaFoto;
        }

        public function getEtichettaImmagine() {
            return $this->etichettaImmagine;
        }
        
        function getCommenti() {
            return $this->commenti;
        }

        function getDatiContenuto() {
            return $this->datiContenuto;
        }
        
        public function getDataPubblicazione() {
            return $this->dataPubblicazione;
        }

        function setCommenti($commenti) {
            $this->commenti = $commenti;
        }

        function setDb($db) {
            $this->db = $db;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setContenutoRiferimento($contenutoRiferimento) {
            $this->contenutoRiferimento = $contenutoRiferimento;
        }

        function setPosizione($posizione) {
            $this->posizione = $posizione;
        }
        
        function setLingua($lingua) {
            $this->lingua = $lingua;
        }

        function setTipo($tipo) {
            $this->tipo = $tipo;
        }
          
        function setAutore($autore) {
            $this->autore = $autore;
        }
        
        function setCategoria($categoria) {
            $this->categoria = $categoria;
        }

        function setMostraNellaHome($mostraNellaHome) {
            $this->mostraNellaHome = $mostraNellaHome;
        }

        function setStato($stato) {
            $this->stato = $stato;
        }

        function setPunteggioSeo($punteggioSeo) {
            $this->punteggioSeo = $punteggioSeo;
        }

        /*
         * Questo metoto imposta il template del contenuto. Il secondo parametro è
         * l'array con i valori ammissibili. Se è diverso da null viene effettuato il
         * controllo. 
         * Se l'array è diverso da null e il template passato in input non è presente 
         * nell'elenco viene inserita una stringa vuota
         */
        function setTemplate($template,$valoriAmmissibili = null) {
            if($valoriAmmissibili==null) {
                $this->template = $template;
            }
            else if($valoriAmmissibili!=null && in_array($template, $valoriAmmissibili)) {
                $this->template = $template;
            }
            else { // se arriva qui significa che la variabile non è nell'array dei valori ammissibili
                $this->template = "";
            }
        }

        function setAttivaBreadcrumbs($attivaBreadcrumbs) {
            $this->attivaBreadcrumbs = $attivaBreadcrumbs;
        }

        function setTipoVisualizzazione($tipoVisualizzazione) {
            $this->tipoVisualizzazione = $tipoVisualizzazione;
        }

        function setTitolo($titolo) {
            $this->titolo = $titolo;
        }
        
        function setMetaTitolo($metaTitolo) {
            $this->metaTitolo = $metaTitolo;
        }
        
        public function setMostraTitolo($mostraTitolo) {
            $this->mostraTitolo = $mostraTitolo;
        }
        
        function setMetaDescrizione($metaDescrizione) {
            $this->metaDescrizione = $metaDescrizione;
        }
        
        function setDescrizione($descrizione) {
            $this->descrizione = $descrizione;
        }

        function setAlias($alias) {
            $this->alias = $alias;
        }

        public function setCssGenerato($cssGenerato): void {
            $this->cssGenerato = $cssGenerato;
        }
        
        function setCssAggiuntivo($cssAggiuntivo) {
            $this->cssAggiuntivo = $cssAggiuntivo;
        }

        function setTesto($testo) {
            $this->testo = $testo;
        }

        public function getDataUltimaModifica() {
            return $this->dataUltimaModifica;
        }
        
        function setFoto($foto): void {
            $this->foto = $foto;
        }

        public function setMiniaturaFoto($miniaturaFoto): void {
            $this->miniaturaFoto = $miniaturaFoto;
        }

        public function setEtichettaImmagine($etichettaImmagine): void {
            $this->etichettaImmagine = $etichettaImmagine;
        }
        
        function setDatiContenuto($datiContenuto): void {
            $this->datiContenuto = $datiContenuto;
        }
        
        public function setDataPubblicazione($dataPubblicazione): void {
            $this->dataPubblicazione = $dataPubblicazione;
        }

        public function setDataUltimaModifica($dataUltimaModifica): void {
            $this->dataUltimaModifica = $dataUltimaModifica;
        }

    }